#include <windows.h>
#include <wingdi.h>
#include <shlwapi.h>
#include <stdio.h>

const RGBQUAD g_palette[] =
{
	{ 0x00, 0x00, 0x00, 0x00 },
	{ 0x11, 0x55, 0x11, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00 },
	{ 0x99, 0x00, 0x99, 0x00 },
	{ 0xDD, 0x66, 0xDD, 0x00 },
	{ 0x00, 0x66, 0x00, 0x00 },
	{ 0x33, 0xBB, 0x22, 0x00 },
	{ 0x00, 0x00, 0x88, 0x00 },
	{ 0x00, 0x00, 0xFF, 0x00 },
	{ 0xDD, 0x00, 0x00, 0x00 },
	{ 0xFF, 0xBB, 0xBB, 0x00 },
	{ 0x55, 0xBB, 0xBB, 0x00 },
	{ 0x66, 0xFF, 0xFF, 0x00 },
	{ 0x99, 0xCC, 0xEE, 0x00 },
	{ 0xCC, 0xEE, 0xFF, 0x00 },
	{ 0xEE, 0xEE, 0xFF, 0x00 }
};

#define width  288
#define height 184

unsigned char * make_bmpskelton(int *size, unsigned char **pat)
{
	int bits = 4;
	int outwidth = (width / (8 / bits) + 3) & ~3;
	int colors = 1 << bits;
	int dataofs =
		sizeof(BITMAPFILEHEADER) +
		sizeof(BITMAPINFOHEADER) +
		sizeof(RGBQUAD) * colors;
	int outsize = 
		dataofs + 
		outwidth * height;
	unsigned char *bmp = malloc(outsize);
	if(!bmp) return NULL;
	{
		BITMAPFILEHEADER *bfh = (BITMAPFILEHEADER *)bmp;
		bfh->bfType = 'MB';
		bfh->bfSize = outsize;
		bfh->bfOffBits = dataofs;
	}
	{
		BITMAPINFO *bi = (BITMAPINFO *)(bmp + sizeof(BITMAPFILEHEADER));
		bi->bmiHeader.biSize = sizeof(bi->bmiHeader);
		bi->bmiHeader.biWidth = width;
		bi->bmiHeader.biHeight = height;
		bi->bmiHeader.biPlanes = 1;
		bi->bmiHeader.biBitCount = bits;
		bi->bmiHeader.biCompression = 0;
		bi->bmiHeader.biSizeImage = 0;
		bi->bmiHeader.biXPelsPerMeter = 1;
		bi->bmiHeader.biYPelsPerMeter = 1;
		bi->bmiHeader.biClrUsed = 0;
		bi->bmiHeader.biClrImportant = 0;

		memcpy(bi->bmiColors, g_palette, sizeof(RGBQUAD) * colors);
	}

	*size = outsize;
	*pat = bmp + dataofs;
	return bmp;
}

int main(int argc, char *argv[])
{
	FILE *fp;
	char *outpath;
	unsigned char *planes;
	unsigned char *bmp;
	unsigned char *pat;
	int filelen;
	int bmpsize;

	if(argc != 2) return 1;

	bmp = make_bmpskelton(&bmpsize, &pat);
	if(!bmp) return 1;

	outpath = malloc(strlen(argv[1]) + _MAX_EXT);
	if(!outpath) return 1;
	strcpy(outpath, argv[1]);
	if(!PathRenameExtension(outpath, ".bmp")) return 1;

	fp = fopen(argv[1], "rb");
	if(!fp) return 1;

	fseek(fp, 0, SEEK_END);
	filelen = ftell(fp);
	rewind(fp);
	if(filelen != 33120) return 1;

	planes = malloc(filelen);
	if(!planes) return 1;

	if(fread(planes, filelen, 1, fp) != 1) return 1;

	fclose(fp);

	{
		int planesize = width / 8 * height;
		int outwidth = width / 2;
		int x, y, i;
		int inshift, outshift;
		int inofs, outofs;
		unsigned char *mp = planes;
		unsigned char *rp = mp + planesize;
		unsigned char *gp = rp + planesize;
		unsigned char *bp = gp + planesize;
		unsigned char *ip = bp + planesize;

		memset(pat, 0, outwidth * height);
		for(y = inofs = outofs = 0; y < height; ++y)
		{
			for(x = 0; x < width; ++inofs, x += 8)
			{
				for(i = outshift = 0, inshift = 7; i < 8; outofs += (i & 1), ++i, --inshift)
				{
					int val = ((rp[inofs] >> inshift) & 1) << 0;
					val    |= ((gp[inofs] >> inshift) & 1) << 1;
					val    |= ((bp[inofs] >> inshift) & 1) << 2;
					val    |= ((ip[inofs] >> inshift) & 1) << 3;
					outshift = 4 - outshift;
					pat[outofs] |= val << outshift;
				}
			}
		}
	}

	fp = fopen(outpath, "wb");
	if(!fp) return 1;

	fwrite(bmp, bmpsize, 1, fp);
	
	fclose(fp);

	return 0;
}
